<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePracticeTestsTable extends Migration
{
    public function up()
    {
        Schema::create('practice_tests', function (Blueprint $table) {
            $table->id('Test_id'); // BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('Lesson_id');
            $table->unsignedBigInteger('User_id');
            $table->decimal('Score', 5, 2);
            $table->timestamp('Attempt_date');
            $table->boolean('Passed')->default(false);
            $table->foreign('Lesson_id')->references('Lesson_id')->on('lessons')->onDelete('cascade');
            $table->foreign('User_id')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('practice_tests');
    }
}
